<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class PaymentController extends Controller
{
    public function checkout(Request $request)
    {
        $validated = $request->validate([
            'reseller_id' => 'required|exists:resellers,id',
            'amount' => 'required|numeric|min:10',
        ]);

        return response()->json([
            'payment_url' => 'https://mock-gateway.com/pay/' . \Illuminate\Support\Str::random(10),
            'reseller_id' => $validated['reseller_id'],
            'amount' => $validated['amount']
        ]);
    }

    public function callback(Request $request)
    {
        $reseller = \App\Models\Reseller::find($request->reseller_id);
        if (!$reseller) return response()->json(['error' => 'Reseller not found'], 404);

        $reseller->increment('balance', $request->amount);

        \App\Models\Transaction::create([
            'reseller_id' => $reseller->id,
            'amount' => $request->amount,
            'type' => 'credit',
        ]);

        return response()->json(['message' => 'Payment successful and balance updated']);
    }
}
