<?php

namespace App\Http\Controllers\Api\Reseller;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        // For demonstration, fetch the first reseller. 
        // In real app, this would be based on auth user.
        $reseller = \App\Models\Reseller::first();

        return response()->json([
            'balance' => $reseller->balance,
            'active_clients' => $reseller->activationCodes()->where('status', 'active')->count(),
            'recent_actions' => $reseller->transactions()->latest()->limit(5)->get(),
        ]);
    }
}
