<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\UserPreference;
use Illuminate\Http\Request;

class UserPreferencesController extends Controller
{
    /**
     * Get current user's preferences
     */
    public function show(Request $request)
    {
        $prefs = UserPreference::firstOrCreate(
            ['user_id' => $request->user()->id],
            [] // defaults come from migration
        );

        return response()->json($prefs);
    }

    /**
     * Save / update user preferences
     */
    public function update(Request $request)
    {
        $request->validate([
            'favorite_club'               => 'nullable|string|max:100',
            'favorite_sport'              => 'nullable|string|max:100',
            'favorite_series'             => 'nullable|string|max:100',
            'favorite_star'               => 'nullable|string|max:100',
            'favorite_genre'              => 'nullable|string|max:100',
            'favorite_movie'              => 'nullable|string|max:100',
            'country'                     => 'nullable|string|max:100',
            'city'                        => 'nullable|string|max:100',
            'notify_new_episodes'         => 'nullable|boolean',
            'notify_live_matches'         => 'nullable|boolean',
            'notify_new_movies'           => 'nullable|boolean',
            'notify_subscription_expiry'  => 'nullable|boolean',
        ]);

        $prefs = UserPreference::updateOrCreate(
            ['user_id' => $request->user()->id],
            $request->only([
                'favorite_club', 'favorite_sport',
                'favorite_series', 'favorite_star', 'favorite_genre', 'favorite_movie',
                'country', 'city',
                'notify_new_episodes', 'notify_live_matches',
                'notify_new_movies', 'notify_subscription_expiry',
            ])
        );

        return response()->json(['message' => 'تم حفظ التفضيلات', 'preferences' => $prefs]);
    }
}
