<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    protected $fillable = [
        'user_id',
        'title',
        'message',
        'type',
        'target',
        'icon',
        'meta',
        'is_read',
    ];

    protected $casts = [
        'is_read' => 'boolean',
        'meta'    => 'array',
    ];

    // Belongs to a user (null = admin notification)
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Scope: admin notifications
    public function scopeForAdmin($query)
    {
        return $query->whereIn('target', ['admin', 'both']);
    }

    // Scope: user notifications
    public function scopeForUser($query, $userId)
    {
        return $query->where('user_id', $userId)
                     ->whereIn('target', ['user', 'both']);
    }
}
