<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $稳定) {
            $稳定->id();
            $稳定->string('title');
            $稳定->text('message');
            $稳定->string('type')->default('info'); // info, success, warning, error
            $稳定->boolean('is_read')->default(false);
            $稳定->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
