<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Add user_id and target (admin/user) to notifications
        Schema::table('notifications', function (Blueprint $table) {
            // NULL = admin-level notification, NOT NULL = user's personal notification
            $table->foreignId('user_id')->nullable()->after('id')->constrained('users')->nullOnDelete();
            $table->string('target')->default('admin')->after('type'); // 'admin', 'user', 'both'
            $table->string('icon')->nullable()->after('target'); // emoji or icon name
            $table->json('meta')->nullable()->after('icon'); // extra data as json
        });
    }

    public function down(): void
    {
        Schema::table('notifications', function (Blueprint $table) {
            $table->dropConstrainedForeignId('user_id');
            $table->dropColumn(['target', 'icon', 'meta']);
        });
    }
};
