<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ActivationCodeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $reseller = \App\Models\Reseller::first();

        // One inactive code (for first-time activation)
        \App\Models\ActivationCode::create([
            'code' => 'TEST-123',
            'reseller_id' => $reseller->id,
            'status' => 'inactive',
            'type' => 'all',
        ]);

        // One already active code
        \App\Models\ActivationCode::create([
            'code' => 'ACTIVE-123',
            'reseller_id' => $reseller->id,
            'status' => 'active',
            'expires_at' => \Carbon\Carbon::now()->addMonths(6),
            'type' => 'all',
        ]);
    }
}
